﻿using System;
using System.Collections.Generic;
using System.Web.UI;
using VIRP.EFR.DAL;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class DoDFragment : VIRP_WEB.BaseCode.BaseControl
    {
        DoDFragmentDB manager = new DoDFragmentDB();

        protected void Page_Load(object sender, EventArgs e)
        {
            LoadBaseControls();
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            LoadControlsFromObject();
        }

        public string LabID
        {
            set
            {
                HiddenFieldLabID.Value = value;
            }
        }

        public string PatientID
        {
            set
            {
                HiddenFieldPatientID.Value = value;
            }
        }

        private void LoadControlsFromObject()
        {
            DOD_FRAGMENT_LAB lab = manager.GetDoDFragmentLabById(BaseCode.Helpers.GetIntFromString(HiddenFieldLabID.Value));

            if (lab != null)
            {
                HiddenFieldPatientID.Value = lab.PATIENT_ID.ToString();
                BaseControlLabelLabName.Text = lab.LAB_NAME;
                BaseControlLabelLabReportDate.Text = lab.LAB_REPORT_DATE;
                BaseControlLabelLabCode.Text = lab.LAB_CODE;
                BaseControlLabelLabID.Text = lab.LAB_ID;
                BaseControlLabelLabAccessionNumber.Text = lab.LAB_ACCESSION_NUMBER;
                BaseControlLabelLabProducingEventDate.Text = lab.PRODUCING_EVENT_DATE;

                PanelDoDFragmentData.GroupingText = "&nbsp;&nbsp;DoD Fragment Data for Lab - "
                + lab.LAB_NAME + "&nbsp;&nbsp;";
            }
        }

        private void LoadBaseControls()
        {
            CommonManager commonManager = new CommonManager();
            List<STD_GUI_CONTROL> controls = commonManager.GetStdGuiControlsByCategory("DOD_FRAGMENT_CONTROL", UserSession.CurrentRegistryId);

            foreach (STD_GUI_CONTROL dbItem in controls)
            {
                Control userControl = null;

                userControl = PanelDoDLab.FindControl(dbItem.USER_CONTROL_ID);
                if (userControl != null)
                {
                    BaseControlLabel baseControl = (BaseControlLabel)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL);
                }
            }
        }
    }
}